/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.project.options.includepath;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org2.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;

public class IncludePathEntryDescriptor
implements IXMLPreferencesStorable {
    private String entryKind = "";
    private String contentKind = "";
    private String path = "";
    private String resourceName = "";
    private boolean isExported = false;
    private boolean createdReference = false;

    public IncludePathEntryDescriptor() {
    }

    public String getContentKind() {
        return this.contentKind;
    }

    public void setContentKind(String contentKind) {
        this.contentKind = contentKind;
    }

    public boolean isCreatedReference() {
        return this.createdReference;
    }

    public void setCreatedReference(boolean createdReference) {
        this.createdReference = createdReference;
    }

    public String getEntryKind() {
        return this.entryKind;
    }

    public void setEntryKind(String entryKind) {
        this.entryKind = entryKind;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public void setExported(boolean isExported) {
        this.isExported = isExported;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public IncludePathEntryDescriptor(IncludePathEntry entry, IPath projectPath) {
        this.entryKind = IncludePathEntry.entryKindToString(entry.entryKind);
        this.contentKind = IncludePathEntry.contentKindToString(entry.contentKind);
        if (entry.resource != null) {
            this.resourceName = entry.resource.getName();
        }
        this.isExported = entry.isExported;
        this.createdReference = false;
        IPath entryPath = entry.path;
        if (entry.entryKind != 4 && entry.entryKind != 5 && projectPath != null && projectPath.isPrefixOf(entryPath)) {
            if (entryPath.segment(0).equals(projectPath.segment(0))) {
                entryPath = entryPath.removeFirstSegments(1);
                entryPath = entryPath.makeRelative();
            } else {
                entryPath = entryPath.makeAbsolute();
            }
        }
        this.path = String.valueOf(entryPath);
    }

    @Override
    public void restoreFromMap(Map map) {
        Map entry = (Map)map.get("javabridge_entry");
        if (entry != null) {
            this.entryKind = (String)entry.get("entryKind");
            this.contentKind = (String)entry.get("contentKind");
            this.path = (String)entry.get("path");
            this.resourceName = (String)entry.get("resourceName");
            this.isExported = Boolean.valueOf((String)entry.get("isExported"));
            this.createdReference = Boolean.valueOf((String)entry.get("referenceWasCreated"));
        }
    }

    @Override
    public Map storeToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("entryKind", this.entryKind);
        map.put("contentKind", this.contentKind);
        map.put("path", this.path);
        map.put("resourceName", this.resourceName);
        map.put("isExported", new Boolean(this.isExported));
        map.put("referenceWasCreated", new Boolean(this.createdReference));
        HashMap<String, HashMap<String, Object>> entry = new HashMap<String, HashMap<String, Object>>(1);
        entry.put("javabridge_entry", map);
        return entry;
    }
}

